%Script for solving nonlinear regression problems in MATLAB
%Copyright 2015 Yuri Shardt
%To be used in conjunction with Chapter 7 of the Springer book, Statistics
%for Chemical and Process Engineers: A Modern Approach.

%Entering the raw data
VVo=[1.00034 0.80465 0.75358 0.71548 0.68588 0.66600 0.65913 0.64004 0.62661];
pi=[0.29278 0.57172 0.85514 1.13595 1.43349 1.72908 2.02815 2.32660 2.66704];

%Solve the problem to obtain the parameter estimates and associated
%information
[param,residual,J,covb] = nlinfit(pi,VVo,'volume',[0.2,0.56]);
CI=nlparci(param,residual,'covar',covb);


%display the results
fprintf(['b*: %f%f\n'],param(1),(CI(1,2)-CI(1,1))/2);
fprintf(['B: %f%f\n'],param(2),(CI(2,2)-CI(2,1))/2);

%examine the residuals
normplot(residual);
figure;plot(VVo,residual,'ok');xlabel('Measured value');ylabel('Residual');
figure;plot(pi,residual,'ok');xlabel('First Regressor');ylabel('Residual');
figure;plot(residual,'ok');xlabel('Sample');ylabel('Residual');
